<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- Edited by XMLSpy -->
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method='html' version='1.0' encoding='UTF-8' indent='yes'/>

<xsl:template match="/">
  <html>
  <title>www.btl.com</title>
  <head>

<style type="text/css">

        .style1
        {
            width: 100%;
            border: 1px solid #0169B2;
	    text-align: justify;
        }

        .style2
        {
            font-family: Verdana;
            font-size: Medium;
	    font-weight: bold;
            color: blue;
            background-color: #60C1EB;
	    text-align: center;
        }

        .style3
        {
            width: 100%;
	    border: 2px solid #0169B2;
	    text-align: left;
            font-family: Verdana;            
            font-size: xx-small;
	    border-color: #60C1EB;
	    align:center
        }
        .style4
        {
            font-family: Verdana;
            font-size: small;
	    font-weight: bold;
            color: blue;
            background-color: #BBC777;
	    text-align: left;
        }

        .style5
        {
            width: 60%;
	    border: 2px solid #0169B2;
	    text-align: left;
            font-family: Verdana;            
            font-size: xx-small;
	    border-color: #60C1EB;
	    align:center
        }
</style>

 </head>

  <body>

    <table class="style3" cellpadding="2" cellspacing="2">
      <tr class="style2">
	<td  colspan="3">Configuration Delivery</td>
      </tr>

     <tr>
	<td  colspan="3">&#160; </td>
      </tr>

     <tr class="style4">
	<td  colspan="3">Keys</td>
      </tr>

      <tr bgcolor="#9acd32">
        <th align="left">Config Item</th>
	<th align="left">Value</th>
	<th align="left">Description</th>
      </tr>

<xsl:comment><!-- Begening of Key. Each IF block contains a Key item,value and its description.  --></xsl:comment>   


      <xsl:for-each select="configuration/keys/key">
	  
	 <xsl:if test="@name = 'mode'">
      	      <tr>	
		    <td>Mode</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>Describes the mode in which the data layer is running</td>
	      </tr>
      	  </xsl:if>

	  <xsl:if test="@name = 'contentPath'">
      	      <tr>	
		    <td>Content Path</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>Base path of cp3 content. This is pre-appended to the url</td>
	      </tr>
      	  </xsl:if>

	  <xsl:if test="@name = ' AssetsLocation '">
      	      <tr>	
		    <td>Assets Location</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>Describes which assets to use in the UI (images, css etc)</td>
	      </tr>
      	  </xsl:if>

	  <xsl:if test="@name = 'fontPath'">
      	      <tr>	
		    <td>Font Path</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used by assessment engine in mark &amp; verify scripts </td>
	      </tr>
      	  </xsl:if>



	  <xsl:if test="@name = 'playerPath'">
      	      <tr>	
		    <td>Player Path</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used by assessment engine in mark &amp; verify scripts </td>
	      </tr>
      	  </xsl:if>


	  <xsl:if test="@name = 'BASE_CONTENT_PATH'">
      	      <tr>	
		    <td>Base Content Path</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used by assessment engine in mark &amp; verify scripts </td>
	      </tr>
      	  </xsl:if>



	  <xsl:if test="@name = 'AbsolutePathToPage'">
      	      <tr>	
		    <td>Absolute Path To Page</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used by assessment engine in mark &amp; verify scripts </td>
	      </tr>
      	  </xsl:if>

	
	  <xsl:if test="@name = 'timerInterval'">
      	      <tr>	
		    <td>Timer Interval</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>

	
	  <xsl:if test="@name = 'stateCheckInterval'">
      	      <tr>	
		    <td>State Check Interval</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>



	
	  <xsl:if test="@name = 'percentageDecimalPlaces'">
      	      <tr>	
		    <td>Percentage Decimal Places</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>



	
	  <xsl:if test="@name = 'percentageDecimalPlaces'">
      	      <tr>	
		    <td>Percentage Decimal Places</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>




	
	  <xsl:if test="@name = 'showColourPreferencesButton'">
      	      <tr>	
		    <td>Show Colour Preferences Button</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>



	
	  <xsl:if test="@name = 'timeWarningIntervals'">
      	      <tr>	
		    <td>Time Warning Intervals</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>It describes when the delivery engine should warn the candidate how much time is remaining (in milliseconds)</td>
	      </tr>
	  </xsl:if>

	  <xsl:if test="@name = 'exportOnFinishInPackagedVersion'">
		  <tr>
			  <td>Export when the Finish button is pressed.</td>
			  <td><xsl:value-of select="@value"/></td>
			  <td>It defines if the spreadsheet questions should be exported, when the the packaged exam is finished.</td>
		  </tr>
	  </xsl:if>



	
	  <xsl:if test="@name = 'timeWarningIntervalWindow'">
      	      <tr>	
		    <td>Time Warning Interval Window</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>It describes how long the timeWarning reminder should be visible (in milliseconds)</td>
	      </tr>
      	  </xsl:if>



	
	  <xsl:if test="@name = 'timeIntervalDisplayLocation'">
      	      <tr>	
		    <td>Time Interval Display Location</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>**</td>
	      </tr>
      	  </xsl:if>	

	
	  <xsl:if test="@name = 'contentRequestMode'">
      	      <tr>	
		    <td>Content Request Mode</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>It describes how content is requested by player, either via normal http or via secureContentRequestUrl</td>
	      </tr>
      	  </xsl:if>	


	
	  <xsl:if test="@name = 'secureContentRequestUrl'">
      	      <tr>	
		    <td>Secure Content Request Url</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>**</td>
	      </tr>
      	  </xsl:if>	


	
	  <xsl:if test="@name = 'timeOut'">
      	      <tr>	
		    <td>Time Out</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Number of seconds before web service connection will be considered to have timed out</td>
	      </tr>
      	  </xsl:if>


	
	  <xsl:if test="@name = 'ExitOnError'">
      	      <tr>	
		    <td>Exit On Error</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used to describe if the application exits when an error is reported to user</td>
	      </tr>
      	  </xsl:if>


	  <xsl:if test="@name = ' DetailedCommunicationError '">
      	      <tr>	
		    <td> Detailed Communication Error </td>
		    <td><xsl:value-of select="@value"/></td>
		    <td>Used to describe whether to display error messages from server</td>
	      </tr>
      	  </xsl:if>

	

	  <xsl:if test="@name = 'ContentLocation'">
      	      <tr>	
		    <td>Content Location</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Used by assessment engine in mark &amp; verify scripts </td>
	      </tr>
      	  </xsl:if>
					
	

	  <xsl:if test="@name = 'ToolsConfigLocation'">
      	      <tr>	
		    <td>Tools Config Location</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>
					
	

	  <xsl:if test="@name = 'ShowZoomButton'">
      	      <tr>	
		    <td>Show Zoom Button</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> **</td>
	      </tr>
      	  </xsl:if>
	

	  <xsl:if test="@name = 'version'">
      	      <tr>	
		    <td>Version</td>
		    <td><xsl:value-of select="@value"/></td>
		    <td> Displayed on login screens &amp; about dialog</td>
	      </tr>
      	  </xsl:if>
    </xsl:for-each>
</table>	
<br/>
			
<xsl:comment> Begening of colourPreferences. </xsl:comment> 
<xsl:comment>Each IF block contains a colourPreferences COlour Name and value(here value will bgcolor of next column. --</xsl:comment>  
    

<table class="style5" cellpadding="2" cellspacing="2">  

        <tr class="style4">
	   <td  colspan="5">Colour Preferences</td>
        </tr>


        <tr bgcolor="#9acd32">
	    <th align="left" width="20%">Background Colour</th>
            <th align="left" width="20%">Foreground Colour</th>	    
            <th align="left" width="20%">Background Colour code</th>
	    <th align="left" width="20%">Font Colour code</th>
	    <th align="left" width="20%">Colour on Display</th>
      	</tr>
	 

      <xsl:for-each select="configuration/colourPreferences/option">

	<xsl:variable name="bgColor" select="substring(background/@col,3)" />	  
	<xsl:variable name="forColor" select="substring(foreground/@col,3)" />
	  


      	  <tr>	
		<td><xsl:value-of select="background/@name"/></td>		
		<td><xsl:value-of select="foreground/@name"/></td>		
		<td>#<xsl:value-of select="substring(background/@col,3)"/></td>
		<td>#<xsl:value-of select="substring(foreground/@col,3)"/></td>
		<td bgcolor= "#{$bgColor}" align="center"><font color="#{$forColor}"><b>Sample Text</b></font></td>	
	  </tr>
	
   </xsl:for-each>
</table>

</body>
</html>
</xsl:template>
</xsl:stylesheet>
