/***
* BTLPopupManager function is instantiated by the  swf in the delivery.html 
* This is referenced as ToolManager and manages the direct communication with the delivery swf
*/
var ToolManager = function (swfId) {
	var that = this;
	var _swf = null;
	var _id = null;
	var _data = null;
	var _diagramClose = false;
	var _promptForSave = false;
	var _readOnly = false;
	
	var popups = {}; // dictionary of popups so action script class can refer to correct page content

	var init = function () {
		_swf = document.getElementById(swfId);
	};

	/***
	 * Create a popup for the external tool. This is loaded into an IFrame inside a jquery Dialog
	 * If a popup with the same id already exists,
	 * then a reference object is returned.
	 *
	 * @param id the id of the popup
	 * @param data, the data to load into the tool
	 */
	this.createPopup = function(id, data, promptForSave, readOnly) {
		_id = id;
		_data = data;
		_diagramClose = false;
		_promptForSave = promptForSave;
		_readOnly = readOnly;
		
		console.log('createPopup - readOnly : ' + readOnly);
		
		var popup = null;
		
		if (popups[id]) {
			// already exists
			popup = popups[id];
		}
		else {
			popup = jQuery("#externalTool")
			.dialog({
				autoOpen: false,
				draggable: true,
				resizable: true,
				modal: false,
				width: 1024,
				height: 570,
				dialogClass: "diagram-dialog"
			})
			.dialogExtend({
			        "maximizable" : true,
			        "icons" : {
			          "maximize" : "ui-icon-arrow-4-diag"
			        }
			      });
			
			// remove containment from the dialog, allowing to be dragged outside the bounds of the viewport
      		//popup.dialog("widget").draggable({ containment: false });
      
			//attach content
			that.loadToolTemplate(id, popup, "tools/diagramCreator/index.html");
			popups[id] = popup;
			
			// bind the close event - stop dialog from closing unless the close is triggered by the diagramCreator
			that.bindCloseDialog(popup);
		}

		return popup;
	};

	this.show = function(popup) {
		popup.dialog("open");
	};

	// Call the DiagramCreator to ask it to check for dirty and load the Save/Close dialog.
	// The Tool will call back to saveAndQuit or discardAndQuit functions.
	this.bindCloseDialog = function (popup) {
		popup.on("dialogbeforeclose", function( event, ui ) {
			if (!_diagramClose)
			{
				$('#toolFrame').get(0).contentWindow.closeDiagramCreator();
				event.stopPropagation();
				return false;
			}
			return true;
		});
	};

	/*
		Functions that send responses back to the Flash swf
	*/
	
	// We are loading this tool into an IFrame in the dialog
	this.loadToolTemplate = function (id, popup, template) {
		popup.find("#toolContent").append($("<iframe id='toolFrame' class='toolPopup' />")
				.attr("src", template));
		_swf.toolPopupOpened(id);
	};

	this.autoSave = function (data) {
		if (popups[_id]) {
			_swf.toolPopupData(_id, data);
		}
	};

	this.saveAndQuit = function (data) {
		if (popups[_id]) {
			// already exists
			_swf.toolPopupClosed(_id, data);
			_diagramClose = true;
			popups[_id].dialog("close");
			popups[_id].find("#toolContent").empty();
			popups[_id] = null;
			return true;
		}
		return true;
	};
	
	this.discardAndQuit = function () {
		if (popups[_id]) {
			_swf.toolPopupCancelled(_id);
			_diagramClose = true;
			popups[_id].dialog("close");
			popups[_id].find("#toolContent").empty();
			popups[_id] = null;
			return true;
		}
		return true;
	};
	
	this.closeOnly = function () {
		if (popups[_id]) {
			_diagramClose = true;
			popups[_id].dialog("close");
			popups[_id].find("#toolContent").empty();
			popups[_id] = null;
			return true;
		}
	};
	
	/*
	* Public Getters
	*/
	this.getLoadData = function() {
		return _data;
	};
	
	this.getPromptForSave = function() {
		return _promptForSave;
	}
	
	this.getReadOnly = function() {
		console.log('getReadOnly - _readOnly : ' + _readOnly);
		return _readOnly;
	}
	
	jQuery(document).ready(function(){
		init();
	});
};