/***
* toolHostCallbacks function is instantiated by the  swf in the SecureAssessDelivery.html 
* This is referenced as toolHostCallbacks and manages the direct communication with the delivery swf
*/

var toolHostCallbacks = function (swfId) {
	var self = this;
	var _swf = null;
	
	// Dictionaries of toolPopups and data so we can launch multiple tools.
	var tools = {};
	
	var init = function () {
		_swf = document.getElementById(swfId);
	};

	/*
	* Setup the tool from the data xml
	*/
	this.getTool = function (id, model){
		var tool = null;
		
		if (tools[id]) {
			// already exists
			tool = tools[id];
		}
		else {
			var popupManager = new toolPopupManager();
			tool = popupManager.createTool(id, model);
			tool.data("id",id);
			tool.data("model",model);
			tool.data("toolClose",false);
			tools[id] = tool;
		}
		popupManager.show(tool);
		
		self.updateDialogToCorrectVieportWidth(tool);
		
		_swf.genericToolOpened(id);
	};
	
	/*****************************************************************
	* Tool Communications
	*****************************************************************/
	this.closeAllTools = function () {
		Object.keys(tools).forEach(function(key, index) {
				if(tools[key] != null)
				{
					tools[key].data("toolClose",true);
					tools[key].dialog("close");
				}			
			}, tools);
		tools = {};
	};
	
	this.close = function (id) {
		if (tools[id]) {
			self.hideTool(id);
			self.clearTool(id);
			_swf.genericToolClosed(id);
			return true;
		}
	};
	
	this.hide = function (id) {
		if (tools[id]) {
			self.hideTool(id);
			return true;
		}
	};

	this.getToolData = function(id) {
		return tools[id].data("model");
	};
	
	this.updateDialogToCorrectVieportWidth = function(tool) {	
		// NOTE(abbas): The jquery dialog doesn't give us the right width for the viewport (some gets up by an outer div), so we're just
		// going to get the different between outer div (which has the width we want) and the iframe (which is the thing we want to be the right size)
		// and add it to the outer element
		// IMPORTANT(abbas): You want to call this function AFTER updating the jquery dialog width so the values queried here are correct.
		var widthDeciderElem = tool[0].parentElement;
		var expectedWidth = parseInt(widthDeciderElem.style.width);
		var paddedWidth = (expectedWidth + (expectedWidth - parseInt(tool.find('iframe').css('width'))));
		widthDeciderElem.style.width = (paddedWidth + 'px');
		
		// NOTE: We need this to notify the dialog of the new window (otherwise restore after maximise doesn't behave)
		tool.dialog( "option", "width", paddedWidth );
	}
	
	this.resizeTool = function (id, width, height) {
		if (tools[id]) {
			var tool = tools[id];
			tool.dialog( "option", "width", width );
			self.updateDialogToCorrectVieportWidth(tool);
			
			// NOTE(abbas): the dialog will expand the height to accomated the iframe
			tool.find('iframe').css('height', height + 'px');
		}
	};
	
	this.setWindowTitle = function(id, title) {
		if(tools[id]) 
		{
			tools[id].dialog("option", "title", title);
		}
	}
	
	this.hideTool = function(id) {
		tools[id].data("toolClose",true);
		tools[id].dialog("close");
	};
	
	this.clearTool = function(id) {
		tools[id] = null;
	};
	
	jQuery(document).ready(function(){
		init();
	});
}