define(["require", "exports", "./helpers"], function (require, exports, helpers_1) {
    "use strict";
    var ToolHost = (function () {
        function ToolHost() {
            this._toolHostCallbacks = null;
            this._id = null;
            this.close = function () {
                if (this._toolHostCallbacks && this._toolHostCallbacks.close) {
                    this._toolHostCallbacks.close(this._id);
                }
            };
            this.getToolData = function () {
                var loadData = null;
                if (this._toolHostCallbacks && this._toolHostCallbacks.getToolData) {
                    loadData = this._toolHostCallbacks.getToolData(this._id);
                }
                return loadData;
            };
            this.resizeTool = function (width, height) {
                if (this._toolHostCallbacks && this._toolHostCallbacks.resizeTool) {
                    this._toolHostCallbacks.resizeTool(this._id, width, height);
                }
            };
            this.logCandidateEvent = function (logMessage) {
                if (this._toolHostCallbacks && this._toolHostCallbacks.logCandidateEvent) {
                    this._toolHostCallbacks.logCandidateEvent(this._id, logMessage);
                }
            };
            this._id = helpers_1.Helpers.getURLParameter('id');
            if (window.parent == null) {
                if (typeof (toolHostCallbacks) !== undefined) {
                    this._toolHostCallbacks = toolHostCallbacks;
                }
            }
            else {
                if (typeof (window.parent.toolHostCallbacks) !== undefined) {
                    this._toolHostCallbacks = window.parent.toolHostCallbacks;
                }
            }
        }
        ToolHost.prototype.setWindowTitle = function (title) {
            if (this._toolHostCallbacks && this._toolHostCallbacks.setWindowTitle) {
                this._toolHostCallbacks.setWindowTitle(this._id, title);
            }
        };
        return ToolHost;
    }());
    exports.ToolHost = ToolHost;
});
