function initHtmlHighlighter(cssContent, localStorageKey, buttonColor, buttonBackColor, highLightText, undoHighLightText) {
	$('body').wrapInner('<div class="question" />');
	$('.question').wrapInner('<div class="introduction-text" />');

	var style = document.createElement('style');
	style.type = 'text/css';
	style.innerHTML = cssContent;
	document.getElementsByTagName('body')[0].appendChild(style);

	rangy.init();
	highlighter = rangy.createHighlighter();
	highlighter.addClassApplier(rangy.createClassApplier("mark"));

	$(".introduction-text").textHighlight({
		highlighter: highlighter,
		mouseX: 0,
		mouseY: 0,
		disableForElements: ['.mjx-chtml'],
		autoSerializeEnabled: true,
		localStorageKey: localStorageKey
	});

	var serializedData = localStorage.getItem(localStorageKey);
	if (serializedData)
		highlighter.deserialize(serializedData);

	if (buttonColor && buttonBackColor) {
		$("#highlighter-pen").css("background-color", buttonBackColor);
		$("#remove-highlight").css("background-color", buttonBackColor);
		window.parent.getColourPreferencesTxtColour = function () {
			return null;
		};
		window.parent.getStyleProfileBtnTextColour = function () {
			return buttonColor;
		};
	}

	if (highLightText && undoHighLightText) {
		window.parent.getHighlighterLocalization = function () {
			return {
				highlight: highLightText,
				remove: undoHighLightText
			};
		};
	}

};