﻿function AspireIntegration(productId) {
    var self = this,
        internalProductId = "",
        isReady = false,
        attempt = 0,
        messageType = {
            expired: 'expiredRelogin',
            ready: 'ready',
            lastActivityTimeUpdate: 'lastActivityTimeUpdate'
        };

    switch (productId) {
        case "Itembank":
            internalProductId = "TestCreation";
            break;
        case "AssessmentCentral":
            internalProductId = "TestAdministration";
            break;
    }

    self.notifyReady = function () {
        isReady = true;
    };

    self.notifyActivityDetected = function () {
        if (parent) {
            parent.postMessage(
                JSON.stringify({
                    type: messageType.lastActivityTimeUpdate,
                    id: internalProductId,
                    lastActivityTimeUpdate: true
                }), "*");
        }
    };

    self.notifySessionExpired = function () {
        if (parent) {
            parent.postMessage(
                JSON.stringify({
                    type: messageType.expired,
                    id: internalProductId,
                    expired: true
                }), "*");
        }
    };

    self.notifyAuthorizationComplete = function () {
        if (parent) {
            parent.postMessage(
                JSON.stringify({
                    type: messageType.ready,
                    id: internalProductId,
                    ready: true
                }), "*");
        }
    };

    var transmitToken = function (data) {
        try {
            attempt++;

            return data.relogin 
                ? setNewToken(productId, data.token) 
                : getPermissionForToken(productId, data.token, data.userName, data.permission);
        }
        catch (e) {
            console.log(e);
        }

        if (attempt < 30) {
            setTimeout(function () { transmitToken(data); }, 1000);
        }
        else {
            self.notifyAuthorizationComplete();
        }
    };

    $(window).on("message", function (ev) {
        if (!parent) {
            return;
        }

        var windowEventData = window.event && window.event.data ? window.event.data : null;

        var data = null;
        try {
            data = JSON.parse(ev.originalEvent.data);
        }
        catch (e) { }

        if (!data && windowEventData) {
            data = JSON.parse(windowEventData);
        }

        if (data) {
            attempt = 0;
            transmitToken(data);
        }
    });
}