/***
* toolPopupManager function is instantiated by toolHostCallbacks.js when we need to create a new tool popup
* This is referenced as toolPopupManager and manages the loading and display of tool popups
*/

var toolPopupManager = function () {
	var self = this;
	var _id = null;
	var _data = null;
	var _width = 800;
	var _height = 600;
	var _modal = false;
	var _resizable = false;
	var	_name = "example";
		
	/***
	 * Create a tool for the external tool. This is loaded into an IFrame inside a jquery Dialog
	 * If a tool with the same id already exists, then a reference object is returned.
	 *
	 * @param id the id of the tool
	 * @param data, the data to load into the tool
	 */
	this.createTool = function(id, data) {
		_id = id;
		_data = data;
		var tool = null;

		// set the parameters from the data xml
		self.setParameters();
		
		tool = self.openNewPopup();

		return tool;
	};
	
	/***
	 * Open a new popup with the correct parameters
	 */
	this.openNewPopup = function() {
		var popup = jQuery("<div class='toolContainer'><span></span></div>")
				.dialog({
					autoOpen: false,
					draggable: true,
					resizable: _resizable,
					modal: _modal,
					width: _width,
					height: 'auto',
					dialogClass : "toolDialog",
					closeOnEscape: false
				})
				.dialogExtend({
						"maximizable" : _resizable,
						"icons" : {
						  "maximize" : "ui-icon-arrow-4-diag"
						}
					  });
		
		// remove containment from the dialog, allowing to be dragged outside the bounds of the viewport
  		//popup.dialog("widget").draggable({ containment: false });
		
		//attach content
		var toolPath = self.getToolPath();
		self.loadToolTemplate(popup, toolPath, _height);
		self.bindCloseDialog(popup);
		
		return popup;
	};

	// Read the tool Name from the data to build the path to the tool
	this.getToolPath = function () {
		var toolPath = "tools/{path}/index.html?id={id}";
		
		toolPath = toolPath.replace("{path}", _name);
		toolPath = toolPath.replace("{id}", _id);
		
		return toolPath;
	};

	this.loadToolTemplate = function (popup, toolPath, height) {
		// NOTE(abbas): We've set the dialog height to auto and then it should expand to the height of the iFrame
		var iFrameHeightStyle = "style='height:{height}px;'";
		iFrameHeightStyle = iFrameHeightStyle.replace("{height}", height);
		
		popup.find("span").append($("<iframe id=" + _id + " class='toolFrame' " + iFrameHeightStyle + "/>")
				.attr("src", toolPath));
	};
	
	// default parameters expected in the toolXML that are used to define the popup
	this.setParameters = function () {
		_width = self.getXMLValues("width", 800);
		_height = self.getXMLValues("height", 600);
		_name = self.getXMLValues("name", "");
		_modal = helpers.parseBool(self.getXMLValues("modal", "false"));
		_resizable = helpers.parseBool(self.getXMLValues("enableResizing", "false"));
	};
	
	this.getXMLValues = function (tagName, defaultValue) {
		var toolDataXml = helpers.loadXmlDoc(_data);
		var toolNameNode = toolDataXml.getElementsByTagName(tagName)[0];
		if (toolNameNode !== undefined){
			return toolNameNode.textContent === "" ? defaultValue : toolNameNode.textContent;
		}

		return defaultValue;
	};

	// bind the close event of the dialog. This calls a 'closeTool' hook that should exist in all tools to ensure the tool is closed 'generically'!
	this.bindCloseDialog = function (tool) {
		tool.on("dialogbeforeclose", function( event, ui ) {
			if (tool.data("toolClose") === false)
			{
				var id = tool.data("id");
				$('#' + id).get(0).contentWindow.closeTool();
				event.stopPropagation();
				return false;
			}
			return true;
		});
	};
	
	this.show = function(tool) {
		tool.dialog("open");
	};

}