define(["require", "exports"], function (require, exports) {
    "use strict";
    var Helpers = (function () {
        function Helpers() {
        }
        Helpers.getURLParameter = function (name) {
            return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [null, ''])[1].replace(/\+/g, '%20')) || null;
        };
        Helpers.prototype.loadXmlDoc = function (xml) {
            var xmlParser = new DOMParser();
            var xmlDoc = xmlParser.parseFromString(xml, "text/xml");
            return xmlDoc;
        };
        Helpers.prototype.isJsonString = function (str) {
            try {
                JSON.parse(str);
            }
            catch (e) {
                return false;
            }
            return true;
        };
        // NOTE(abbas): Ripped from here: https://gist.github.com/chinchang/8106a82c56ad007e27b1
        Helpers.xmlToJson = function (xml) {
            // Create the return object
            var obj = {};
            // element
            if (xml.nodeType == 1) {
                // do attributes
                if (xml.attributes.length > 0) {
                    obj["@attributes"] = {};
                    for (var j = 0; j < xml.attributes.length; j++) {
                        var attribute = xml.attributes.item(j);
                        obj["@attributes"][attribute.nodeName] = attribute.nodeValue;
                    }
                }
            }
            else if (xml.nodeType == 3) {
                obj = xml.nodeValue;
            }
            // do children
            // If just one text node inside
            if (xml.hasChildNodes() && xml.childNodes.length === 1 && xml.childNodes[0].nodeType === 3) {
                obj = xml.childNodes[0].nodeValue;
            }
            else if (xml.hasChildNodes()) {
                for (var i = 0; i < xml.childNodes.length; i++) {
                    var item = xml.childNodes.item(i);
                    var nodeName = item.nodeName;
                    if (typeof (obj[nodeName]) == "undefined") {
                        obj[nodeName] = Helpers.xmlToJson(item);
                    }
                    else {
                        if (typeof (obj[nodeName].push) == "undefined") {
                            var old = obj[nodeName];
                            obj[nodeName] = [];
                            obj[nodeName].push(old);
                        }
                        obj[nodeName].push(Helpers.xmlToJson(item));
                    }
                }
            }
            return obj;
        };
        Helpers.prototype.toolDataToJson = function (toolDataXmlString) {
            var toolData = null;
            var xmlDoc = this.loadXmlDoc(toolDataXmlString);
            if (xmlDoc.childNodes.length > 0) {
                // NOTE(abbas): Passing in the child node so we can go toolData.name rather than toolData.tool.name with the returned json object
                toolData = Helpers.xmlToJson(xmlDoc.childNodes.item(0));
            }
            return toolData;
        };
        Helpers.prototype.parseBool = function (stringValue) {
            var result = true;
            if (stringValue.toLowerCase() === "false" || stringValue === "0" || stringValue === "") {
                result = false;
            }
            return result;
        };
        return Helpers;
    }());
    exports.Helpers = Helpers;
});
