
/***
 * spreadsheets - an array of objects
 {	title: "title of the spreadsheet",
     xml: spread-xml-as-a-string
 }

 if a string is passed it's considered as spreadsheet xml string
 if an object is passed it should has the following structure
 {	title: "title of the spreadsheet",
     xml: spread-xml-as-a-string
 }
 */
function openNewTab(sections, title) {
    // -webkit-print-color-adjust to keep colors for the printing version
    var keepColors = '<style>body {-webkit-print-color-adjust: exact !important;color-adjust: exact; }</style>';
    var SPREADSHEET_CSS = 'HtmlTable.css';
    var SPREADSHEET_JS = 'HtmlTable.js';
    var listOfSections = [];

    if(typeof sections === 'array' || sections instanceof Array) {
        listOfSections = sections;
    //} else if(typeof sections === 'string' || sections instanceof String) {
    //    listOfSections = [{xml: sections}]
    } else if(sections instanceof Object) {
        listOfSections = [sections]
    }


    var html = '<!DOCTYPE html><head><title>HtmlTable examples</title>'
        + keepColors
        +'<link href="' + SPREADSHEET_CSS + '" rel="stylesheet" type="text/css"/>'
        +'<script src="js/jquery-1.12.4.min.js" type="text/javascript"><'
        +'/script>'
        +'<script src="xml2json.min.js" type="text/javascript"><'
        +'/script>'
        +'<script src="' + SPREADSHEET_JS + '" type="text/javascript"><'
        +'/script>'
        +'<script type="text/javascript">HtmlTable.init();<'
        +'/script>'
        +'</head>'
        +'<body>';

    if(title) {
        html += '<h1>' + 'Exam Name: ' + title + '</h1>';
    }

    for(var i = 0; i < listOfSections.length; i++) {
		if(listOfSections[i].orderId != -1) {
        	html +=
            '<h1>'
            //+ listOfSections[i].orderId + '. '
            + listOfSections[i].name
            + '</h1>';
		}
        for(var j = 0; j < listOfSections[i].questions.length; j++) {
            html += getSpreadSheetTagHTML(listOfSections[i].questions[j]);
        }
    }

    html += '</body></html>';

    var newWindow = window.open();
    newWindow.document.write(html);
    newWindow.document.close();

}
/**
 * Function which generates the html for a spreadsheet based on the passed data
 * spreadsheetData.title = "Question 1"
 * spreadSheetData.xml - the xml of the spreadsheet
 * questionNumber - the number of questions
 */
function getSpreadSheetTagHTML(spreadsheetData) {
    var html = '';
    var title = spreadsheetData.name;

    if(spreadsheetData.hasAttempted == false) {
        html += '<div class="exam-response">';
        html += '<h1>' + title + ": Not Attempted." + '</h1>';
        html += '</div>';
        return html;
    }

	var hasTitle = true;
	if(spreadsheetData.orderId == -1) {
		hasTitle = false;
	}

    html += '<div class="exam-response">';
	if(hasTitle) {
    	html +=
        '<h1>'
        + title
        + '</h1>';
	}
    html +=
        '<sheet>'
        + spreadsheetData.userXML
        +'</sheet>';
    html += '</div>';

    return html;
}
